package rabbit.zip;

import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/** GZipState for uncompressing the gzip data 
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
class UnCompressor implements GZipUnpackState {
    private GZipUnpackListener listener;
    private Inflater inf;
    private CRC32 crc;
    private byte[] buf;
    private int off;
    private int len;

    public UnCompressor (GZipUnpackListener listener) {
	this.listener = listener;
	inf = new Inflater (true);
	crc = new CRC32 ();
    }
    
    public void handleCurrentData (GZipUnpacker unpacker) {
	byte[] unpacked = listener.getBuffer ();
	int num = -1;
	try {
	    if ((num = inf.inflate (unpacked)) > 0) {
		crc.update (unpacked, 0, num);
		listener.unpacked (unpacked, 0, num);
	    }
	} catch (DataFormatException e) {
	    listener.failed (e);
	    return;
	} finally {
	    listener.returnBuffer (unpacked);
	}
	if (num == 0) {
	    if (inf.finished () || inf.needsDictionary ()) {
		listener.dataUnpacked ();
		int remaining = inf.getRemaining ();
		long length = inf.getBytesWritten ();
		long cs = crc.getValue ();
		GZipUnpackState tr = 
		    new TrailReader (listener, length, cs);
		inf.end ();
		unpacker.setState (tr);
		tr.handleBuffer (unpacker, buf, off + len - remaining, remaining);
	    }
	}
	return;
    }

    public boolean needsInput () {
	return inf.needsInput ();
    }

    public void handleBuffer (GZipUnpacker unpacker, 
			      byte[] buf, int off, int len) {
	inf.setInput (buf, off, len);
	this.buf = buf;
	this.off = off;
	this.len = len;
	handleCurrentData (unpacker);
    }
}
