package rabbit.zip;

/** A class that can unpack gzip streams in chunked mode.
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
public class GZipUnpacker {
    private GZipUnpackState state;

    public GZipUnpacker (GZipUnpackListener listener) {
	state = new MagicReader (listener);
    }

    /** Check if the unpacker currently needs more data 
     */
    public boolean needsInput () {
	return state.needsInput ();
    }
    
    /** Add more compressed data to the unpacker.
     */
    public void setInput (byte[] buf, int off, int len) {
	state.handleBuffer (this, buf, off, len);
    }

    /** Handle the next block of the current data. 
     */
    public void handleCurrentData () {
	state.handleCurrentData (this);
    }

    public void setState (GZipUnpackState state) {
	this.state = state;
    }
}
