package rabbit.zip;

/** A class that can pack gzip streams in chunked mode.
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
public class GZipPacker {
    private GZipPackState state;
    
    public GZipPacker (GZipPackListener listener) {
	state = new HeaderWriter (listener);
    }

    /** Check if the unpacker currently needs more data 
     */
    public boolean needsInput () {
	return state.needsInput ();
    }

    /** Add more compressed data to the unpacker.
     */
    public void setInput (byte[] buf, int off, int len) {
	state.handleBuffer (this, buf, off, len);
    }

    public void finish () {
	state.finish ();
    }

    public boolean finished () {
	return state.finished ();
    }

    /** Handle the next block of the current data. 
     */
    public void handleCurrentData () {
	state.handleCurrentData (this);
    }

    public void setState (GZipPackState state) {
	this.state = state;
    }
}
