package rabbit.proxy;

import rabbit.util.TrafficLogger;

/** A class to track of multiple network flows. 
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
public class TrafficLoggerHandler {
    // normal client traffic
    private TrafficLogger client;
    
    // normal web connections (real servers or proxy up the chain).
    private TrafficLogger network;
    
    // cached resources
    private TrafficLogger cache;
    
    // internally generated by this proxy
    private TrafficLogger proxy;
    
    public TrafficLoggerHandler () {
	client = new SimpleTrafficLogger ();
	network = new SimpleTrafficLogger ();
	cache = new SimpleTrafficLogger ();
	proxy = new SimpleTrafficLogger ();
    }

    public TrafficLogger getClient () {
	return client;
    }

    public TrafficLogger getNetwork () {
	return network;
    }
    
    public TrafficLogger getCache () {
	return cache;
    }

    public TrafficLogger getProxy () {
	return proxy;
    }

    public void addTo (TrafficLoggerHandler other) {
	client.addTo (other.client);
	network.addTo (other.network);
	cache.addTo (other.cache);
	proxy.addTo (other.proxy);
    }

    public void clear () {
	client.clear ();
	network.clear ();
	cache.clear ();
	proxy.clear ();
    }
}
