package rabbit.proxy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import rabbit.http.HttpHeader;
import rabbit.io.BufferHandle;
import rabbit.io.HandlerRegistration;
import rabbit.io.SelectorRegistrator;
import rabbit.io.SocketHandler;
import rabbit.io.WebConnection;

/** A base for client resource transfer classes.
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
abstract class ResourceHandlerBase implements ClientResourceHandler {
    protected Connection con;
    protected BufferHandle bufHandle;
    protected TrafficLoggerHandler tlh;
    protected WebConnection wc;
    protected ClientResourceTransferredListener listener;
    private SelectionKey sk;
    private int readStartPos = 0;

    public ResourceHandlerBase (Connection con, 
				BufferHandle bufHandle,
				TrafficLoggerHandler tlh) {
	this.con = con;
	this.bufHandle = bufHandle;
	this.tlh = tlh;
    }
    
    /**  Will store the variables and call doTransfer ()
     */
    public void transfer (WebConnection wc,  
			  ClientResourceTransferredListener crtl) {
	this.wc = wc;
	this.listener = crtl;
	doTransfer ();
    }
    
    protected void doTransfer () {
	if (!bufHandle.isEmpty ())
	    sendBuffer ();
	else 
	    waitForRead ();
    }
    
    abstract void sendBuffer ();

    protected void waitForRead () {
	bufHandle.possiblyFlush ();
	SocketHandler sh = new Reader ();
	try {
	    sk = SelectorRegistrator.register (con.getLogger (), 
					       con.getChannel (), 
					       con.getSelector (), 
					       SelectionKey.OP_READ, sh);
	} catch (IOException e) {
	    listener.failed (e);
	}
    }
    
    private class Reader implements SocketHandler {
	public void run () {
	    try {
		String r = "ResourceHandlerBase.Reader.run()";
		SelectorRegistrator.unregister (con.getSelector (), sk, this, r);
		ByteBuffer buffer = bufHandle.getBuffer ();
		buffer.limit (buffer.capacity ());
		int read = con.getChannel ().read (buffer);
		if (read == 0) {
		    waitForRead ();
		} else if (read == -1) {
		    failed (new IOException ("Failed to read request"));
		} else {
		    tlh.getClient ().read (read);
		    buffer.flip ();
		    sendBuffer ();
		}
	    } catch (IOException e) {
		listener.failed (e);
	    }
	}

	public void timeout () {
	    bufHandle.possiblyFlush ();
	    listener.timeout ();
	}

	public boolean useSeparateThread () {
	    return false;
	}

	public String getDescription () {
	    return toString ();
	}
    }

    public void timeout () {
	bufHandle.possiblyFlush ();
	listener.timeout ();
    }

    public void failed (Exception e) {
	bufHandle.possiblyFlush ();
	listener.failed (e);
    }
}
