package rabbit.cache;

/** A key to use when searching the cache.
 *
 *  This class only exists to trick equals/hashCode that we
 *  have the same key. 
 *
 * @author <a href="mailto:robo@khelekore.org">Robert Olofsson</a>
 */
class MemoryKey<K> extends FiledKey<K> {
    private static final long serialVersionUID = 20060606;
    private K data;

    public MemoryKey (K data) {
	this.data = data;
	hashCode = data.hashCode ();
    }

    @Override public K getData () {
	return data;
    }
}
