/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.util.Date;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;

public class SIG0Signer {
    private static final short VALIDITY = 300;
    private int algorithm;
    private PrivateKey privateKey;
    private Name name;
    private int footprint;

    public SIG0Signer(int algorithm, PrivateKey privateKey, Name name, int keyFootprint) {
        this.algorithm = (byte)algorithm;
        this.privateKey = privateKey;
        this.name = name;
        this.footprint = keyFootprint;
    }

    public SIG0Signer(int algorithm, PrivateKey privateKey, Name name, PublicKey publicKey) {
        this.algorithm = (byte)algorithm;
        this.privateKey = privateKey;
        this.name = name;
        KEYRecord keyRecord = KEYConverter.buildRecord(name, 1, 0L, 0, 255, publicKey);
        this.footprint = keyRecord.getFootprint();
    }

    /*
     * WARNING - void declaration
     */
    public void apply(Message m, byte[] old) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        void var8_7;
        String algorithmName;
        int validity = Options.intValue("sig0validity");
        if (validity < 0) {
            validity = 300;
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        if (this.algorithm == 3) {
            algorithmName = "SHA1withDSA";
        } else if (this.algorithm == 1) {
            algorithmName = "MD5withRSA";
        } else if (this.algorithm == 5) {
            algorithmName = "SHA1withRSA";
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm");
        }
        SIGRecord tmpsig = new SIGRecord(Name.root, 255, 0L, 0, this.algorithm, 0L, timeExpires, timeSigned, this.footprint, this.name, null);
        byte[] outBytes = DNSSEC.digestMessage(tmpsig, m, old);
        Signature signer = Signature.getInstance((String)var8_7);
        signer.initSign(this.privateKey);
        signer.update(outBytes);
        byte[] signature = signer.sign();
        if (this.algorithm == 3) {
            DSAKey dsakey = (DSAKey)((Object)this.privateKey);
            signature = DSASignature.create(dsakey.getParams(), signature);
        }
        SIGRecord sig = new SIGRecord(Name.root, 255, 0L, 0, this.algorithm, 0L, timeExpires, timeSigned, this.footprint, this.name, signature);
        m.addRecord(sig, 3);
    }
}

