/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Type;
import org.xbill.DNS.Verifier;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;

public class DNSSECVerifier
implements Verifier {
    private Map trustedKeys = new HashMap();

    public synchronized void addTrustedKey(KEYRecord key) {
        Name name = key.getName();
        LinkedList<KEYRecord> list = (LinkedList<KEYRecord>)this.trustedKeys.get(name);
        if (list == null) {
            list = new LinkedList<KEYRecord>();
            this.trustedKeys.put(name, list);
        }
        list.add(key);
    }

    public void addTrustedKey(Name name, PublicKey key) {
        KEYRecord keyrec = KEYConverter.buildRecord(name, 1, 0L, 0, 3, key);
        if (keyrec != null) {
            this.addTrustedKey(keyrec);
        }
    }

    private PublicKey findMatchingKey(Iterator it, int algorithm, int footprint) {
        while (it.hasNext()) {
            KEYRecord keyrec = (KEYRecord)it.next();
            if (keyrec.getAlgorithm() != algorithm || keyrec.getFootprint() != footprint) continue;
            return KEYConverter.parseRecord(keyrec);
        }
        return null;
    }

    private synchronized PublicKey findTrustedKey(Name name, int algorithm, int footprint) {
        List list = (List)this.trustedKeys.get(name);
        if (list == null) {
            return null;
        }
        return this.findMatchingKey(list.iterator(), algorithm, footprint);
    }

    private PublicKey findCachedKey(Cache cache, Name name, int algorithm, int footprint) {
        RRset[] keysets = cache.findAnyRecords(name, 25);
        if (keysets == null) {
            return null;
        }
        RRset keys = keysets[0];
        return this.findMatchingKey(keys.rrs(), algorithm, footprint);
    }

    private PublicKey findKey(Cache cache, Name name, int algorithm, int footprint) {
        PublicKey key = this.findTrustedKey(name, algorithm, footprint);
        if (key == null && cache != null) {
            return this.findCachedKey(cache, name, algorithm, footprint);
        }
        return key;
    }

    /*
     * WARNING - void declaration
     */
    private int verifySIG(RRset set, RRSIGRecord sigrec, Cache cache) {
        PublicKey key = this.findKey(cache, sigrec.getSigner(), sigrec.getAlgorithm(), sigrec.getFootprint());
        if (key == null) {
            return 0;
        }
        Date now = new Date();
        if (now.compareTo(sigrec.getExpire()) > 0 || now.compareTo(sigrec.getTimeSigned()) < 0) {
            System.err.println("Outside of validity period");
            return -1;
        }
        byte[] data = DNSSEC.digestRRset(sigrec, set);
        switch (sigrec.getAlgorithm()) {
            case 1: {
                byte[] sig = sigrec.getSignature();
                String algString = "MD5withRSA";
                break;
            }
            case 3: {
                byte[] sig = DSASignature.create(sigrec.getSignature());
                String algString = "SHA1withDSA";
                break;
            }
            case 5: {
                byte[] sig = sigrec.getSignature();
                String algString = "SHA1withRSA";
                break;
            }
            default: {
                return -1;
            }
        }
        try {
            void var7_7;
            void var8_8;
            Signature s = Signature.getInstance((String)var8_8);
            s.initVerify(key);
            s.update(data);
            return s.verify((byte[])var7_7) ? 1 : -1;
        }
        catch (GeneralSecurityException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Signing data: " + e);
            }
            return -1;
        }
    }

    public int verify(RRset set, Cache cache) {
        Iterator sigs = set.sigs();
        if (Options.check("verbosesec")) {
            System.out.print("Verifying " + set.getName() + "/" + Type.string(set.getType()) + ": ");
        }
        if (!sigs.hasNext()) {
            if (Options.check("verbosesec")) {
                System.out.println("Insecure");
            }
            return 0;
        }
        while (sigs.hasNext()) {
            RRSIGRecord sigrec = (RRSIGRecord)sigs.next();
            if (this.verifySIG(set, sigrec, cache) != 1) continue;
            if (Options.check("verbosesec")) {
                System.out.println("Secure");
            }
            return 1;
        }
        if (Options.check("verbosesec")) {
            System.out.println("Failed");
        }
        return -1;
    }
}

